clear; 
 rng(0)
%% Extract the regression coefficients of converters and AD
clinicalState= {'HC_avg.mat','EMCI_avg.mat', 'LMCI_avg.mat', 'AD_avg.mat'};  
totalSubject = 460;
subjectNumber = 0;
regressionCoefficient =[];
allSubjectID =[];
for state = 1:numel(clinicalState)
    load(char(clinicalState(state)));
    regressionCoefficient = [regressionCoefficient {subjectgene.betasAvg}];
    allSubjectID = [allSubjectID subjectgene.RID];
    subjectNumber = subjectNumber + numel (subjectgene);
end

numberOfGene = 976;
numberOfFactor = 6;
allBeta = zeros (subjectNumber,numberOfGene*numberOfFactor^2);

for sub = 1:subjectNumber
        beta =  regressionCoefficient{sub}(9:end,:);
        allBeta(sub,:) = reshape(beta,1,[]);   
end

%% Load the IDs diseased subjects and pick the columns of coefficients whose 99% CI excludes zero

load ('postRegressSubjectID');
IdDiseased = diseasedID; 

indexDiseased = find (ismember(allSubjectID, IdDiseased));
numberOfDiseased = numel(IdDiseased);

lowCI = mean(allBeta(indexDiseased,:)) - 2.58*std(allBeta(indexDiseased,:))/sqrt(numberOfDiseased);
highCI= mean(allBeta(indexDiseased,:)) + 2.58*std(allBeta(indexDiseased,:))/sqrt(numberOfDiseased);

signLow = sign (lowCI);
signHigh = sign (highCI);

reliableBetaIndex = find (signLow == signHigh);
reliableBeta = allBeta(indexDiseased,reliableBetaIndex);


%% Compute singluar value decomposition between gene-imaging coefficients and cognitive scores

load('cognitiveScores');

for subj = 1:length (IdDiseased)

index1 = find (IdCogScores==IdDiseased(subj));

mMSE = MMSE(index1);
aDAS11 = ADAS11(index1);
aDAS13 = ADAS13(index1);
age1 = visitTimes(index1);

index2 = find (IdForEFandMEM==IdDiseased(subj));

mEM = MEM(index2);
eF = EF(index2);
age2 = visitTimesForEFandMEM(index2);

regressionCoef = [regress(mMSE,[ones(size(age1,1), 1) age1]) regress(aDAS11,[ones(size(age1,1), 1) age1]) regress(aDAS13,[ones(size(age1,1), 1) age1]) regress(mEM,[ones(size(age2,1), 1) age2]) regress(eF,[ones(size(age2,1), 1) age2])]; 

cogSlope(subj,:) = regressionCoef(2,:);
end

%% Compute singluar value decomposition between gene-imaging coefficients and slope of cognitive score

[PC_pcntvar,R,Xcontr_on_PCs,XExpected_contr,XExpected_contr_PCs,V,U,Vs,Us,X_order, singVal, newV] = SVD_multivariate_analysis(cogSlope,reliableBeta,[], [],5);

%% Perform permutation analysis

[numberOfSubject, numberOfFeature] = size (reliableBeta);
numberOfPerm = 10000;

for n=1:numberOfPerm
    fprintf('Permuation number %d ', n);
    permutation = randperm (numberOfSubject);
    Y = cogSlope(permutation,:);
    X = reliableBeta;
    [pcntvar_perm,~,contr_perm,expect_perm,~,~,U_perm,~,~,~, singVal_new, newV_perm]  = SVD_multivariate_analysis(Y,X,[], [], 5);
    
    [d, z, rotated] = procrustes(newV',newV_perm');
    V_perm = newV_perm * singVal_new * rotated.T;
    V_perm= sqrt(sum(V_perm.^2));
    A = diag(V_perm);
    singVal_perm(n,:) = diag(A')/norm(diag(A'),1);
    
end

p_values = mean(singVal_perm>diag(singVal)');


%% Perform boostrapping of the first PC

numberOfBoot = 10000;

U_boot = zeros(numberOfBoot,numberOfFeature);
U_boot_flip = zeros(numberOfBoot,numberOfFeature);
pcntvar_boot = zeros(numberOfBoot, 1);

U = U(1,:);

for n=1:numberOfBoot
    sprintf ('permutation number: %d',n)
    perm = datasample(1:numberOfDiseased, numberOfDiseased);
    X = reliableBeta(perm,:);
    Y = cogScore(perm,:);
    [pcntvar_boot(n),~,contr_boot,expect_boot,~,~,U_boot(n,:),~,~,~, ~, ~]  = SVD_multivariate_analysis(Y,X,[], [],1);
    U_boot_flip(n,:) = abs(U_boot(n,:)).*sign(U);
end

%% Evaluate bootstrap ratio and select top genes
StdError = std(U_boot_flip);
bootRatio = abs(U./StdError);
significantBetaIndex = find (bootRatio>2.58);

significantBetaIndexActual = reliableBetaIndex(significantBetaIndex);
geneContribution = zeros (numberOfFactor*6*numberOfGene,1);
geneContribution(significantBetaIndexActual) = 1; 

%% Extract the names of top genes and the factors they modulate
load('landmarkGenesInfo');
geneName = landmarkGenesInfo.gene_names;

indices = zeros (numberOfGene, numberOfFactor); %sort to have each gene by six factors consecutively
for i = 1:numberOfGene
    for n =1:numberOfFactor
indices(i,n) = numberOfGene*(n-1)+i;
    end
end
indices = reshape (indices', 1, []);

for fac= 1:numberOfFactor
    %% Gene name extraction
    geneFactor = geneContribution(numberOfGene*numberOfFactor*(fac-1)+1:numberOfGene*numberOfFactor*fac);
    geneFactor = geneFactor(indices);
    rowIndex = find(geneFactor);
    geneInteraction = {};
    
    mergedRow = ceil(rowIndex/6);
    mergedFactor = mod (rowIndex,6);
    mergedFactor (mergedFactor==0)= 6;
    geneRow = unique(mergedRow);
    %
    for uniqueGene = 1:length (geneRow)
        n = find (mergedRow == geneRow(uniqueGene));
        geneIndex = geneRow(uniqueGene);
        geneInteraction(uniqueGene,:) = {geneName(geneIndex), mergedFactor(n)};
    end
    % geneImaging contains 6 by 1 struct, each row represents a
    % longitudinal biological factor (1=CBF, 2=amyloid, 3=funtional
    % activity, 4= metabolism 5=Grey matter density 6=tau
    
    %In each row, the gene and the factor directly modulated can be found
    geneImaging(fac).interact = geneInteraction;
end

%% Evaluate total contributions of each top gene on PC1
varianceBoot = var (U_boot_flip);
significantVar = varianceBoot(significantBetaIndex);
U_significant = U(significantBetaIndex);

significantGene = mod (significantBetaIndexActual, numberOfGene);
significantGene(significantGene==0) = numberOfGene;

uniqueGene = unique (significantGene, 'stable');
U_final = zeros(numel(uniqueGene),1);
stdError_final = zeros (numel(uniqueGene),1);
geneName = geneName(uniqueGene);
for k = 1: length (uniqueGene)
    index = find (significantGene==uniqueGene(k));    
    if length(index) >1
        U_final (k) = sum (abs(U_significant(index)));
    else
        U_final (k) = sum (U_significant(index));
    end
    stdError_final (k) =  sqrt (sum(significantVar(index)));
end


